# Aplikasi Keuangan Kontrakan

Aplikasi web untuk mengelola keuangan kontrakan, termasuk iuran bulanan penghuni dan pengeluaran kontrakan.

## Fitur

- Manajemen iuran bulanan penghuni kontrakan
- Pencatatan pengeluaran kontrakan
- Perhitungan total pemasukan dan pengeluaran
- Penyimpanan data lokal menggunakan localStorage
- Tampilan modern dan responsif

## Teknologi yang Digunakan

- Next.js 14
- React
- TypeScript
- Tailwind CSS
- Context API untuk state management

## Cara Menjalankan Aplikasi

1. Clone repositori ini
2. Install dependensi:
   ```bash
   npm install
   ```
3. Jalankan aplikasi dalam mode development:
   ```bash
   npm run dev
   ```
4. Buka [http://localhost:3000](http://localhost:3000) di browser Anda

## Cara Deploy

Aplikasi ini dapat di-deploy ke Vercel dengan mudah:

1. Buat akun di [Vercel](https://vercel.com)
2. Install Vercel CLI:
   ```bash
   npm install -g vercel
   ```
3. Login ke Vercel:
   ```bash
   vercel login
   ```
4. Deploy aplikasi:
   ```bash
   vercel
   ```

## Struktur Proyek

- `app/` - Direktori utama aplikasi Next.js
  - `context/` - Context API untuk state management
  - `dues/` - Halaman untuk mengelola iuran
  - `expenses/` - Halaman untuk mengelola pengeluaran
  - `globals.css` - Styling global
  - `layout.tsx` - Layout utama aplikasi
  - `page.tsx` - Halaman utama

## Lisensi

MIT 