import type { Metadata } from 'next';
import { Inter } from 'next/font/google';
import './globals.css';
import { AppProvider } from './context/AppContext';

const inter = Inter({ subsets: ['latin'] });

export const metadata: Metadata = {
  title: 'Keuangan Kontrakan',
  description: 'Aplikasi untuk mengelola keuangan kontrakan',
};

export default function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  return (
    <html lang="id">
      <body className={`${inter.className} bg-gray-50 min-h-screen`}>
        <AppProvider>
          <div className="min-h-screen flex flex-col">
            <nav className="bg-white shadow-sm">
              <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="flex justify-between h-16">
                  <div className="flex">
                    <div className="flex-shrink-0 flex items-center">
                      <a href="/" className="text-xl font-bold text-blue-600">Keuangan Kontrakan</a>
                    </div>
                  </div>
                </div>
              </div>
            </nav>
            <main className="flex-grow max-w-7xl w-full mx-auto py-6 sm:px-6 lg:px-8">
              {children}
            </main>
          </div>
        </AppProvider>
      </body>
    </html>
  );
}
