'use client';
import React from 'react';
import Link from 'next/link';
import { useApp } from './context/AppContext';

export default function HomePage() {
  const { getTotalIncome, getTotalExpenses, getBalance, dues } = useApp();

  const getPaidAmount = () => {
    return dues.reduce((total, due) => {
      return total + due.tenants.reduce((sum, tenant) => {
        return sum + (tenant.hasPaid ? tenant.amount : 0);
      }, 0);
    }, 0);
  };

  return (
    <div className="min-h-screen bg-gray-50">
      <div className="max-w-7xl mx-auto py-12 px-4 sm:px-6 lg:px-8">
        <div className="text-center">
          <h1 className="text-4xl font-bold text-gray-900 mb-8">Aplikasi Keuangan Kontrakan</h1>
          
          <div className="grid grid-cols-1 md:grid-cols-3 gap-6 mb-12">
            <div className="bg-white rounded-lg shadow p-6">
              <h2 className="text-lg font-medium text-gray-900 mb-2">Total Pemasukan</h2>
              <p className="text-3xl font-bold text-green-600">Rp {getPaidAmount().toLocaleString()}</p>
              <p className="text-sm text-gray-500 mt-2">Total iuran yang sudah dibayar</p>
            </div>
            
            <div className="bg-white rounded-lg shadow p-6">
              <h2 className="text-lg font-medium text-gray-900 mb-2">Total Pengeluaran</h2>
              <p className="text-3xl font-bold text-red-600">Rp {getTotalExpenses().toLocaleString()}</p>
              <p className="text-sm text-gray-500 mt-2">Total pengeluaran kontrakan</p>
            </div>
            
            <div className="bg-white rounded-lg shadow p-6">
              <h2 className="text-lg font-medium text-gray-900 mb-2">Saldo</h2>
              <p className="text-3xl font-bold text-blue-600">Rp {(getPaidAmount() - getTotalExpenses()).toLocaleString()}</p>
              <p className="text-sm text-gray-500 mt-2">Saldo saat ini</p>
            </div>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 gap-6 max-w-2xl mx-auto">
            <Link href="/dues" className="block p-6 bg-white rounded-lg shadow hover:shadow-md transition-shadow">
              <h2 className="text-xl font-semibold text-gray-900 mb-2">Iuran Kontrakan</h2>
              <p className="text-gray-600">Kelola iuran bulanan penghuni kontrakan</p>
            </Link>
            
            <Link href="/expenses" className="block p-6 bg-white rounded-lg shadow hover:shadow-md transition-shadow">
              <h2 className="text-xl font-semibold text-gray-900 mb-2">Pengeluaran</h2>
              <p className="text-gray-600">Catat dan kelola pengeluaran kontrakan</p>
            </Link>
          </div>
        </div>
      </div>
    </div>
  );
} 